package MusicLandscape.util.comparators;

import MusicLandscape.entities.Event;

/**
 * This class represents the concept of comparison of two events. It has a single abstract method that is to be
 * implemented by concrete subclasses which implement concrete modes of comparison, e.g. by attendees, by date or other.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet04
 */
public abstract class MyEventComparator {
    /**
     * Compares two events.
     * <p>
     * The result of the comparison of two events is a measure of "distance" between the tow. Distance is not literal
     * (spatial) distance but more generally the difference between the two measured in some unit. If the two events
     * are equal in a certain sense their distance is zero, if the first argument is smaller than the second (again,
     * in the sense of the (concrete) comparator) their distance is negative, positive otherwise.
     * <p>
     * Example: compare two events by date<br>
     * Event 1 (e1): March 10, 1979<br>
     * Event 2 (e2): April 1, 2000<br>
     * Calling compare of a by-date-comparator: compare(e1,e2) would return a negative number (since e1 is before e2)
     * <p>
     * Comparators may choose to handle comparison of null tracks but are not forced to.
     *
     * @param e1 the one event to compare
     * @param e2 the other event to compare
     * @return a measure of the distance between e1 and e2 in the sense of the comparator
     */
    public abstract int compare(Event e1, Event e2);
}
